<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 04. Jan. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * TableFragment class file. 
 * 
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: TableFragment.php 253 2007-08-01 14:14:10Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_table
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: TableFragment.php 253 2007-08-01 14:14:10Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */

/**
 *
 */
require_once 'OpenDocumentPHP/content/body/table/TableCell.php';
require_once 'OpenDocumentPHP/util/ODPElement.php';

/**
 * TableFragment class.
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_table
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */
class TableFragment extends ODPElement
{
    /**
     * @access      private 
     * @since       0.5.0 - 08. Feb. 2007
     */
    private $cells;
    
    /**
     * @access      private 
     * @since       0.5.0 - 08. Feb. 2007
     */
    private $minx = 9999999;
    
    /**
     * @access      private 
     * @since       0.5.0 - 08. Feb. 2007
     */
    private $maxx = 0;
    
    /**
     * @access      private 
     * @since       0.5.0 - 08. Feb. 2007
     */
    private $miny = 9999999;
    
    /**
     * @access      private 
     * @since       0.5.0 - 08. Feb. 2007
     */
    private $maxy = 0;
    
    /**
     * Constructor method.
     * 
     * @since       0.5.0 - 08. Feb. 2007
     */
    function __construct($elem=null) 
    {         
        if (is_null($elem)) {
           parent::__construct('table:table', '', self::TABLE);
        } else {
           parent::__construct($elem);         
        }
        $this->cells = array ();
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.0 - 08. Feb. 2007
     */
    function setTableName($name) {
        $this->setAttributeNS(self :: TABLE, 'table:name', $name);
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.3 - 23. Jul. 2007
     */
    function getTableName($name) {
        return $this->getAttributeNS(self :: TABLE, 'name');
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.3 - 23. Jul. 2007
     */
    function setName($name) {
        $this->setAttributeNS(self :: TABLE, 'table:name', $name);
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.3 - 23. Jul. 2007
     */
    function getName($name) {
        return $this->getAttributeNS(self :: TABLE, 'name');
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.3 - 23. Jul. 2007
     */
    function setStyleName($name) {
        $this->setAttributeNS(self :: TABLE, 'table:name', $name);
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.3 - 23. Jul. 2007
     */
    function getStyleName($name) {
        return $this->getAttributeNS(self :: TABLE, 'name');
    }

    /**
     * 
     * @access      public
     * @since       0.5.3 - 23. Jul. 2007
     */
    function isProtected()
    {
        $ret = false;
        if ($this->hasAttributeNS(self::TABLE, 'protected')) {
            $ret = ($this->getAttributeNS(self::TABLE, 'protected') === 'true');
        }
        return $ret;
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.3 - 23. Jul. 2007
     */
    function getProtectionPassword()
    {
        $ret = false;
        if ($this->isProtected()) {
            $ret = $this->getAttributeNS(self::TABLE, 'protection-key');
        }
        return $ret;
    }
    
    /**
     * 
     * @access      public
     * @param       bool    $status
     * @param       string  $password
     * @since       0.5.3 - 23. Jul. 2007
     */
    function setProtection($status, $password=null)
    {
        $ret = true;
        if ($status) {
            if (is_string($password)) {
                $this->setAttributeNS(self::TABLE, 'table:protected', 'true');
                $this->setAttributeNS(self::TABLE, 'table:pretection-key', $password);        
            } else {
                $ret = false;
            }
        } else {
                $this->setAttributeNS(self::TABLE, 'table:protected', 'false');                
        }
        return $ret;
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.0 - 08. Feb. 2007
     */
    function getCell($col, $row) {
        $ret = null;
        if (isset ($this->cells[$row]) && isset ($this->cells[$row][$col])) {
            $ret = $this->cells[$row][$col];
        } else {
            $ret = new TableCell(null, $col, $row);
            $this->cells[$row][$col] = $ret;
        }
        return $ret;
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.0 - 08. Feb. 2007
     * @return      TableCell 
     */
    function setCellContent($content, $col, $row) {
        $tmp = $this->getCell($col, $row);
        $tmp->setContent($content);
        return $tmp;
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.0 - 08. Feb. 2007
     */
    private function includeCells() {
        $cells = $this->cells;
        ksort($cells);
        $currentRow = 0;
        foreach ($this->cells as $row => $cols) {
            if ($currentRow < $row -1) {
                $tbRow = $this->documentElement->createElementNS(self :: TABLE, 'table-row');
                $tbRow->setAttributeNS(self :: TABLE, 'table:number-rows-repeated', ($row - $currentRow -1));
                $tbCell = $this->documentElement->createElementNS(self :: TABLE, 'table-cell');
                $tbCell->setAttributeNS(self :: TABLE, 'table:style-name', 'ce1');
                $tbRow->appendChild($tbCell);
                $this->appendChild($tbRow);
            }
            ksort($cols);
            $currentCol = 0;
            $tbRow = $this->documentElement->createElementNS(self :: TABLE, 'table-row');
            foreach ($cols as $col => $cell) {
                if ($currentCol < $col -1) {
                    $tbCell = $this->documentElement->createElementNS(self :: TABLE, 'table-cell');
                    $tbCell->setAttributeNS(self :: TABLE, 'table:number-columns-repeated', ($col - $currentCol -1));
                    $tbRow->appendChild($tbCell);
                }
                $currentCol = $col;
                $tbRow->appendChild($cell->getDocumentFragment());
            }
            $this->appendChild($tbRow);
            $currentRow = $row;
        }
    }
    
    /**
     * 
     * @access      public
     * @since       0.5.0 - 08. Feb. 2007
     */
    function getDocumentFragment() {
        $this->includeCells();
        return $this;
    }   
}
?>